/*////////////////////////////////////////////////////////////////////////////
* ----------------------------------------------------------------------------
* "THE BEER-WARE LICENSE" (Revision 42):
* <s.engelmann@uni-wuppertal.de> wrote this file. As long as you retain this notice you
* can do whatever you want with this stuff. If we meet some day, and you think
* this stuff is worth it, you can buy me a beer in return Sven Engelmann
* ----------------------------------------------------------------------------
*/////////////////////////////////////////////////////////////////////////////
/*//////////////////////////////////////////////////////////////////////
 * ucomm.hpp:
 * 
 * 
*///////////////////////////////////////////////////////////////////////
#ifndef UCOMM_HPP
#define UCOMM_HPP
////////////////////////////////////////////////////////////////////////
#include <string>
#include <sstream>
#include <vector>
#include <iostream>
////////////////////////////////////////////////////////////////////////
using namespace::std;
class userinput
{
	private:
	int _argc;
	string *_argv;
	vector<string> accepted;
	public:
	
	userinput(const int argc, const char *argv[]) : _argc(argc)
	{
		_argv = new string[_argc];
		for(int i = 0; i<_argc; i++)
		{
			_argv[i] = argv[i];
		}
	}
	~userinput(void)
	{
		delete[] _argv;
	}
	void showparams()
	{
		std::cout<<"the accepted input parameters (by user and if not by default) were:"<<std::endl<<"	";
		for(auto &it : accepted)
		{
			std::cout<<it<<" ";
		}
		std::cout<<endl;
	}
	template<class Type> Type parameter(std::string identifier, std::string defaultparameter)
	{
		if(identifier[0] == '-')
		{
			for(int i = 1; i<(_argc-1); i++)
			{
				if(!_argv[i].compare(identifier))
				{
					Type value;
					stringstream temp;
					temp<<_argv[i+1];
					temp>>value;
					accepted.push_back(identifier+" "+_argv[i+1]);
					return value;
				}
			}
			Type value;
			std::stringstream temp;
			temp<<defaultparameter;
			temp>>value;
			accepted.push_back(identifier+" "+defaultparameter);
			return value;
		}
		else
		{
			std::cout<<"input identifier has to begin with '-'."<<std::endl;
		}
		return 0;
	}
};
/*//////////////////////////////////////////////////////////////////////
* EXAMPLE:
* 
* userinput ui(iarc,argv);
* int N = ui.parameter<int>("-N");
* cout<<N<<endl;
*///////////////////////////////////////////////////////////////////////
class configfile
{
	private:
	
	public:
};
////////////////////////////////////////////////////////////////////////
#endif
////////////////////////////////////////////////////////////////////////
