### Roxygen-inzable documentation
#' Paired comparisons of $N=12$ items (Thurstonian modelling)
#'
#' This data set contains synthetic data of 1000 participants on all binary
#' indicators of 12 items. For each paired comparison, participants had to rank
#' the two alternative items according to their preference. It is assumed that 
#' transitivity holds (that is, the data comes from a ranking task). More
#' details can be found in Brown and Maydeu-Olivares (2011), Jansen and Schulze
#' (2023) and Maydeu-Olivares and Böckenholt (2005).
#'
#' @name FC
#' 
#' @docType data
#' 
#' @keywords datasets
#'
#' @usage data(FC)
#'
#' @format A data frame with 1000 observations on 66 variables. For a variable
#' ixiy, the result is the response preferences between item x and item y. It is
#' coded a 1, if item x is preferred over item y, and 0 otherwise.
#' 
#'
#' @references 
#' Brown, A, & Maydeu-Olivares, A. (2011). Item response modeling of forced-choice questionnaires. \emph{Educational and Psychological Measurement}, \emph{71}(3), 460-502. \url{https://doi.org/10.1177/0013164410375112}
#' 
#' Jansen, M. T., & Schulze, R. (2023). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. Manuscript submitted.
#' 
#' Maydeu-Olivares, A., & Böckenholt, U. (2005). Structural equation modeling of paired-comparison and ranking data. \emph{Psychological Methods}, \emph{10}(3), 285-304. \url{https://doi.org/10.1037/1082-989X.10.3.285}.
#'
"FC"



