% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax.lavaan.R
\name{syntax.lavaan}
\alias{syntax.lavaan}
\title{Create lavaan syntax for Thurstonian forced choice analysis}
\usage{
syntax.lavaan(blocks, itf, model, rename_list = NULL)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{model}{A descriptor for the model. Can be one of `'lmean'`,
`'uc'`, `'irt'` or  `'simple2'`, `'simple3'` or `'simple5'`. The Number behind 
the `'simple'` statement defines the Thurstone case.}

\item{rename_list}{A list with two vectors to rename the objects in the syntax.
Vector one is the original names, vector two the new names. Defaults to `NULL`.}
}
\value{
Returns a description of the user-specified model. Typically, the
model is described using the lavaan model syntax. See `lavaan::model.syntax`
for more information. 

#' @details The syntax currently is able to perform model analysis for the
latent utility models (`'simple'` and `'lmean'`; Maydeu-Olivares & Böckenholt, 2005) the 
unconstrained factor model (`'uc'`; Maydeu-Olivares & Böckenholt, 2005) and 
the IRT model(`'irt'`; Maydeu-Olivares & Brown, 2010). Additionally, all
model types can be performed with all types of forced choice designs (full,
block, partially linked block, linked block). For an overview and review see
Jansen and Schulze (2023a,2023b).

The standard naming procedure ixiy, for the comparison of items x and y, 
can be changed by specifying the `rename_list` argument. The first vector of
the schould be the vector of original names, for example 
`c('i1i2','i1i3','i2i3','Trait1','Trait2','Trait3')`
the second vector should contain the new names, for example 
`c('A01E12','A01C13','E01C23','Agree','Extra','Consc')`.
}
\description{
This function writes a lavaan syntax given the specifications of the
Thurstonian forced choice model.
}
\examples{

# read data set FC
data(FC)

# set seed and define blocks
set.seed(1)
blocks <- matrix(sample(1:12,12), ncol = 3)

# define the item-to-factor relation
itf <- rep(1:4,3)

# Create lavaan model syntax
syntax.lavaan(blocks,itf,'irt')


}
\references{
Maydeu-Olivares, A., & Brown, A. (2010). Item response modeling of paired comparison and ranking data. \emph{Multivariate Behavioural Research}, \emph{45}(6), 935-974. \url{https://doi.org/10.1080/00273171.2010.531231}
 
Jansen, M. T., & Schulze, R. (2023a). \emph{Linear factor analytic Thurstonian forced-choice models: Current status and issues}. Manuscript submitted.

Jansen, M. T., & Schulze, R. (2023b). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. Manuscript submitted.

Maydeu-Olivares, A., & Böckenholt, U. (2005). Structural equation modeling of paired-comparison and ranking data. \emph{Psychological Methods}, \emph{10}(3), 285-304. \url{https://doi.org/10.1037/1082-989X.10.3.285}
}
