% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.data.R
\name{sim.data}
\alias{sim.data}
\title{Create data based on Thurstonian model equations}
\usage{
sim.data(nfactor, nitem, nperson, itf, variables = NULL, varcov, lmu,
  loadings, transitive = T, var = 0, fvalues = F, sim = T)
}
\arguments{
\item{nfactor}{The number of factors.}

\item{nitem}{The number of items.}

\item{nperson}{The number of data points (= respondents) to simulate.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{variables}{A vector containing the names of paired comparison variables
to return. If `NULL` (default), all variables are returned.}

\item{varcov}{A matrix defining the variance-covariance matrix of the factors.}

\item{lmu}{A vector defining the latent means of items.}

\item{loadings}{A vector defining the loadings of items.}

\item{transitive}{Logical. Should the data be transitive? If `TRUE`, ranking
data is simulated, else paired comparison data is simulated. Defaults to `TRUE`.}

\item{var}{A vector containing the variances for each paired comparison. Defaults to 0.}

\item{fvalues}{Logical. Should simulated factor values be returned? Defaults to `FALSE`.}

\item{sim}{Logical. Should the simulated data be returned? Defaults to `TRUE`.}
}
\value{
Returns a list containing the true factor scores and the data, or a
matrix containing the data.
}
\description{
Simulates a data set of paired comparisons or ranking data based a Thurstonian
latent utility model.
}
\examples{

nfactor <- 4
nitem <- 12
nperson <- 1000
itf <- rep(1:4,3)
varcov <- diag(1,4)

# latent utility means
set.seed(69)
lmu <- runif(nitem, -1, 1)
loadings <- runif(nitem, 0.30, 0.95)

FC <- sim.data(nfactor=nfactor, nitem=nitem, nperson=nperson, itf=itf, 
varcov = varcov, lmu = lmu, loadings=loadings)
    
}
