% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redundancies.R
\name{redundancies}
\alias{redundancies}
\title{Determine the number of redundancies}
\usage{
redundancies(blocks, warn = T)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{warn}{Logical. Should warning messages be returned? Defaults to `TRUE`.}
}
\value{
Returns an integer of the number of redundancies.
}
\description{
This function determines the number of redundancies among the tetrachoric
correlations and thresholds.
}
\details{
If a ranking design is used (variances of binary indicators is zero)
there are redundancies among the thresholds and tetrachoric correlations to 
be estimated. This is the case, whenever the number of items per block is 
larger than two. In these cases the degrees of freedom must be corrected by
subtracting the redundancies. For more details see Jansen and Schulze (2023)
and Maydeu-Olivares (1999).
}
\examples{

# Define 30 items divided by ten triplets as blocks
blocks <- matrix(c(1:30), ncol = 3)

# define the item-to-factor relation
itf <- rep(1:3,10)

# Determine the redundancies
redundancies(blocks)

}
\references{
Jansen, M. T., & Schulze, R. (2023). \emph{The Thurstonian linked block design: Improving Thurstonian modeling for paired comparison and ranking data}. Manuscript submitted.

Maydeu-Olivares, A. (1999). Thurstonian modeling of ranking data via mean and covariance structure analysis. \emph{Psychometrika}, \emph{64}(3), 325-340. \url{https://doi.org/10.1007/BF02294299}
}
