% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.mplus.R
\name{read.mplus}
\alias{read.mplus}
\title{Reads results from Mplus output file.}
\usage{
read.mplus(blocks, itf, model, output_path = "myFC_model.out",
  convergence = T, fit.stat = T, loading = T, cor = T, intercept = T,
  threshold = T, resvar = T, standardized = F)
}
\arguments{
\item{blocks}{A matrix defining the blocks of the model. The number of rows
must be the number of blocks, each row represents a block and contains the
item numbers. The number of columns present the number of items per block.}

\item{itf}{A vector defining the items-to-factor relation. For example
`c(1,1,1,2,2,2)` defines six items, the first three correspond to factor 1,
the second three correspond to factor 2.}

\item{model}{A descriptor for the model. Can be one of `'lmean'`,
`'uc'`, `'irt'` or  `'simple2'`, `'simple3'` or `'simple5'`. The Number behind 
the `'simple'` statement defines the Thurstone case.}

\item{output_path}{Path to the Mplus output file. Defaults to `'myFC_model.out'`.}

\item{convergence}{Logical. Should a message for convergence be returned?
Defaults to `TRUE`.}

\item{fit.stat}{Logical. Should fit statistics be returned? Defaults to `TRUE`.}

\item{loading}{Logical. Should loading estimates be returned? Defaults to `TRUE`.}

\item{cor}{Logical. Should latent correlation estimates be returned?
Defaults to `TRUE`.}

\item{intercept}{Logical. Should intercepts be returned? Does only work for
`model = 'lmean'`. Defaults to `TRUE`.}

\item{threshold}{Logical. Should thresholds be returned? Does only work for
`model = 'uc'` or `'irt'`. Defaults to `TRUE`.}

\item{resvar}{Logical. Should residual variances be returned? Defaults to `TRUE`.}

\item{standardized}{Logical. Should standardized values be returned? Defaults
to `FALSE`.}
}
\value{
Returns a list containing the specified results, after model analysis.
}
\description{
This function reads and returns results from an Mplus output file.
}
\examples{

# read and save data set FC
data(FC)
write.table(FC,'my_data.dat',quote=FALSE, sep=" ", col.names = FALSE, row.names = FALSE)

# set seed and define blocks
set.seed(1)
blocks <- matrix(sample(1:12,12), ncol = 3)

# define the item-to-factor relation
itf <- rep(1:4,3)

# perform analysis 
fit.mplus(blocksort(blocks),itf,'irt',data_path = 'mydata.dat', data_full = TRUE,
input_path = 'myFC_model')

# After estimation
read.mplus(blocks,itf,'irt',output_path = 'myFC_model.out')
 
}
